<?php

/**
 *	Core Class
 *  --------------
 *	Description : Move functions to objects          DrawCurrencySymbol
 *	Written by  : Kyriazis                           GetSmsProvider
 *	Version     : 1.0.0
 *  Created     : 09/07/2015
 *  Updated	    : 29/07/2015
 *	
 **/

class Core {
    
	public function __construct()
	{		
	}
	
	//==========================================================================
    // Class Destructor
	//==========================================================================
    public function __destruct()
	{
		//echo 'Object has been destroyed';
    }

    //1.4.7.5
    public static function DrawCurrencySymbol($image_width = 30, $image_path = '../', $class = 'vertical-align-middle')
    {
     ## Initialize Connection
     $mysqli = Database::GetConnection();
     
     $sql= "SELECT currency, currency_symbol FROM ".TABLE_CORE_SETTINGS." WHERE id = '1'";
     $result = database_query($mysqli, $sql, DATA_ONLY, FIRST_ROW_ONLY)or die (mysqli_error($mysqli));;
        if ($result['currency_symbol'] == '') {
            $output = '<span>'.$result['currency'].'</span>';
        } else {
            $output = '<img class="'.$class.'" src="'.$image_path.'img/'.$result['currency_symbol'].'" style="width:'.$image_width.'px" />';
        }
     
     return $output;
     ## Close Connection
     mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Returns SMS provider (if any)) 
    ##--------------------------------------------------------------------------    
        public static function GetSmsProvider()
    {
        ## Initialize Connection
        $mysqli = Database::GetConnection();
        $output = '';
        
        $sql= "SELECT sms_provider FROM ".TABLE_CORE_SETTINGS." WHERE id = '1'";
        $result = database_query($mysqli, $sql, DATA_ONLY, FIRST_ROW_ONLY) or die (mysqli_error($mysqli));;
        $output =  $result['sms_provider'];
        
        return $output;
        ## Close Connection
        mysqli_close($mysqli);
    }
    
    
    ##--------------------------------------------------------------------------
    ## Returns SMS mode (LIVE or TEST) 
    ##--------------------------------------------------------------------------      
        public static function GetSmsMode()
    {
        ## Initialize Connection
        $mysqli = Database::GetConnection();
        $output = '';
        
        $sql= "SELECT sms_mode FROM ".TABLE_CORE_SETTINGS." WHERE id = '1'";
        $result = database_query($mysqli, $sql, DATA_ONLY, FIRST_ROW_ONLY) or die (mysqli_error($mysqli));;
        $output =  $result['sms_mode'];
        
        return $output;
        ## Close Connection
        mysqli_close($mysqli);
    }
    
        // Read customer groups from CLS
        public static function AutoSmsSetupExists ()
    {
        $mysqli = Database::GetConnection();
        
        $sql_select = "SELECT id FROM ".TABLE_SMS_AUTO_SETUP." WHERE is_active = 1";		
        $result_select = database_query($mysqli, $sql_select, DATA_AND_ROWS, ALL_ROWS, FETCH_ASSOC, false);
        if ($result_select[1]>0){
            return true;    
        } else {
            return false;
        }
        mysqli_close($mysqli);
    }
    ##--------------------------------------------------------------------------
    ## Returns true when Auto SMS setup in error state 
    ##-------------------------------------------------------------------------- 
        public static function AutoSmsHasErrors()
    {
        $mysqli = Database::GetConnection();
        $sql_select = "SELECT id FROM ".TABLE_SMS_AUTO_SETUP." WHERE error_flag = 1";		
        $result_select = database_query($mysqli, $sql_select, DATA_AND_ROWS, ALL_ROWS);
        if ($result_select[1] > 0){
            return true;    
        } else {
            return false;
        }
        mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Returns user_id 
    ##--------------------------------------------------------------------------
        public static function GetUserId()
    {
        ## Initialize Connection
        $mysqli = Database::GetConnection();
        $logged_user = $_SESSION['user'];
        $output = '';
        
        $sql= "SELECT id AS user_id FROM ".TABLE_USERS." WHERE username = '".$logged_user."'";
        $result = database_query($mysqli, $sql, DATA_ONLY, FIRST_ROW_ONLY) or die (mysqli_error($mysqli));;
        $output =  $result['user_id'];
        
        return $output;
        ## Close Connection
        mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Updates error log table with failed procedures
    ##--------------------------------------------------------------------------
    public static function UpdateErrorLog($error_code, $error_short_description, $error_long_description, $error_severity)
    {
        ## Initialize Connection
        $mysqli = Database::GetConnection();
        $error_user_id = self::GetUserId();
        $output = '';
        
        $sql= "INSERT INTO ".TABLE_ERROR_LOG." (error_id, error_datetime, error_code, error_short_description, error_long_description, error_user_id, error_severity) VALUES (NULL, NOW(), '$error_code', '$error_short_description', '$error_long_description', '$error_user_id', '$error_severity')";
        $result = database_void_query($mysqli, $sql, DATA_ONLY, FIRST_ROW_ONLY) or die (mysqli_error($mysqli));
        
        //if ($error_severity == 'MEDIUM' || $error_severity == 'HIGH') mail('me@localhost', $error_short_description, $error_long_description, 'development@webnail.gr');
        
        ## Close Connection
        mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Returns formatted system error 
    ##--------------------------------------------------------------------------
    public static function DrawSystemMessage($description, $severity = 'ERROR')
    {
        $output = '';
        $css_style = '';
        
        if ($severity == 'ERROR') $css_style = 'critical';
        if ($severity == 'WARNING') $css_style = 'warning';
        if ($severity == 'INFO') $css_style = 'completed';
        if ($severity == 'SUCCESS') $css_style = 'success';
        
        $output = '<div class="'.$css_style.'"><ul><li>'.$description.'</div>';
        return $output;
    }
    
    ##--------------------------------------------------------------------------
    ## Returns string between given characters
    ##--------------------------------------------------------------------------
    public static function StringFromDelimiters($string, $start, $end)
    {
        $output = '';
        $pos = stripos($string, $start);
        $str = substr($string, $pos);
        $str_two = substr($str, strlen($start));
        $second_pos = stripos($str_two, $end);
        $str_three = substr($str_two, 0, $second_pos);
        
        $output = trim($str_three); 
        return $output;

    }
    
    ##--------------------------------------------------------------------------
    ## Returns module status 
    ##--------------------------------------------------------------------------
    public static function ModuleIsInstalled($check_module)
    {
        $mysqli = Database::GetConnection();
        $output = 'no';
        
        $sql_mod = "SELECT id AS mod_id FROM ".TABLE_MODULES." WHERE mod_name = '".$check_module."'";
        $result_mod = database_query($mysqli, $sql_mod, DATA_AND_ROWS, FIRST_ROW_ONLY, FETCH_ASSOC, false) or die (mysqli_error($mysqli));
        if ($result_mod[1] > 0) { $output = 'yes'; } else { $output = 'no'; }
        return $output;
        
        mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Returns distinct rewards categories from reports table 
    ##--------------------------------------------------------------------------
    public static function GetAllReportCategories($year_base)
    {
        global $mysqli;
        
        $sql_all = "SELECT DISTINCT(BI.bi_item) AS bi_item, BI.bi_item_desc 
                    FROM bi_sales_items BI
                    INNER JOIN cls_categories CAT ON CAT.id = BI.bi_item
                    WHERE BI.bi_year = '".(int)$year_base."'
                    ORDER BY CAT.ordering ASC";
        $result_all = database_query($mysqli, $sql_all, DATA_AND_ROWS, ALL_ROWS, FETCH_ASSOC, false) or die (mysqli_error($mysqli));
        return $result_all;
        
        mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Returns category name from reports table 
    ##--------------------------------------------------------------------------
    public static function GetReportCategoryName($bi_item, $year_base)
    {
        global $mysqli;
        
        $sql_name = "SELECT BI.bi_item_desc 
                    FROM bi_sales_items BI
                    WHERE BI.bi_year = '".(int)$year_base."' AND BI.bi_item = '".(int)$bi_item."'
                    ORDER BY BI.id DESC
                    LIMIT 0,1";
        $result_name = database_query($mysqli, $sql_name, DATA_ONLY, FIRST_ROW_ONLY, FETCH_ASSOC, false) or die (mysqli_error($mysqli));
        return $result_name;
        
        mysqli_close($mysqli);
    }
    
    ##--------------------------------------------------------------------------
    ## Returns Installation Owner
    ##--------------------------------------------------------------------------      
        public static function GetInstallationOwner()
    {
        ## Initialize Connection
        $mysqli = Database::GetConnection();
        $output = '';
        
        $sql= "SELECT owner FROM ".TABLE_CORE_SETTINGS." WHERE id = '1'";
        $result = database_query($mysqli, $sql, DATA_ONLY, FIRST_ROW_ONLY) or die (mysqli_error($mysqli));;
        $output =  $result['owner'];
        
        return $output;
        ## Close Connection
        mysqli_close($mysqli);
    }
    
}
?>